function PresentationInformation(pID, totSlides, curIndex, base) {
	this.presentationID = pID;
	this.totalSlides = totSlides;
	this.currentSlideIndex = curIndex;
	this.basePath = base;
}

var Presentations = new Array();

function ShowNextSlide(presentationID, imageID, prevButtonID, nextButtonID, textArea) {
	var presentation = Presentations[presentationID];
	
	if ( presentation.totalSlides == 0 || (presentation.currentSlideIndex == presentation.totalSlides) ) {
		return;
	}

	if ( presentation.currentSlideIndex == 1 ) {
		document.getElementById(prevButtonID).src = CatalogImageBase + "btnPreviousSlide.gif";
	}
	
	presentation.currentSlideIndex++;

	if ( presentation.currentSlideIndex == presentation.totalSlides ) {
		document.getElementById(nextButtonID).src = CatalogImageBase + "btnNextSlideDisabled.gif";
	}
	
	document.getElementById(textArea).innerHTML = presentation.currentSlideIndex;
	document.getElementById(imageID).src = FormatImageFileName(presentation.basePath, presentation.currentSlideIndex);
}

function ShowPrevSlide(presentationID, imageID, prevButtonID, nextButtonID, textArea) {
	var presentation = Presentations[presentationID];
	
	if ( presentation.totalSlides == 0 || (presentation.currentSlideIndex == 1) ) {
		return;
	}

	if ( presentation.currentSlideIndex == presentation.totalSlides ) {
		document.getElementById(nextButtonID).src = CatalogImageBase + "btnNextSlide.gif";
	}

	presentation.currentSlideIndex--;

	if ( presentation.currentSlideIndex == 1 ) {
		document.getElementById(prevButtonID).src = CatalogImageBase + "btnPreviousSlideDisabled.gif";
	}

	document.getElementById(textArea).innerHTML = presentation.currentSlideIndex;
	document.getElementById(imageID).src = FormatImageFileName(presentation.basePath, presentation.currentSlideIndex);
}

function FormatImageFileName(basePath, slideIndex) {
	var filename = slideIndex + '';
	var leadingZeros = 4 - filename.length;
	
	for ( var i = 0; i < leadingZeros; i++ ) {
		filename = "0" + filename;
	}

	return basePath + "/Slide_" + filename + "_Thumb.jpg";
}

function SetErrorSlide(imageID) {
	document.getElementById(imageID).src = CatalogImageBase + "SlideNotFound.jpg";
}
